--> pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO



IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO




USE      BD_Air_France;
CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_pays CHAR(3), cmp_nom VARCHAR(15),
 CONSTRAINT pk_compagnie PRIMARY KEY(cmp_comp));

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6), pil_prenom VARCHAR(15), pil_nom VARCHAR(15), 
 pil_hvol DECIMAL(7,2), cmp_comp VARCHAR(4), pil_chef VARCHAR(6),
 CONSTRAINT pk_pilote PRIMARY KEY(pil_brevet),
 CONSTRAINT fk_pil_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp),
 CONSTRAINT fk_pil_chef_pil FOREIGN KEY(pil_chef) REFERENCES T_pilote_pil(pil_brevet));

INSERT INTO T_compagnie_cmp VALUES ('AF', 'fr', 'Air France');
INSERT INTO T_compagnie_cmp VALUES ('SING','sn', 'Singapore AL');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 'fr', 'Castanet AL');

INSERT INTO T_pilote_pil VALUES ('PL-4', 'Henri','Alqui', 3400, 'AF',NULL);
INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pierre','Lamothe', 450, 'AF', 'PL-4');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Didier','Linxe', 900, 'AF','PL-4');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Michel','Castaings', 1000, 'SING',NULL);


-- exists R16

SELECT t1.pil_brevet, t1.pil_nom, t1.cmp_comp
FROM   T_pilote_pil t1 
WHERE  EXISTS 
      (SELECT t2.pil_brevet FROM T_pilote_pil t2 
       WHERE t2.pil_chef = t1.pil_brevet);

-- R17

SELECT  t1.cmp_comp, t1.cmp_pays, t1.cmp_nom 
FROM    T_compagnie_cmp t1
WHERE NOT EXISTS (SELECT t2.cmp_comp FROM T_pilote_pil t2 WHERE t2.cmp_comp=t1.cmp_comp);



IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO

